/*
 * Copyright (c) 2004 bartavelle
 * bartavelle@bandecon.com
 *
 * Simple MD5 hashes cracker
 * It uses the Solar Designer's md5 implementation
 * 
 */

#include <string.h>

#include "arch.h"
#include "misc.h"
#include "common.h"
#include "formats.h"
#include "md5.h"

#define FORMAT_LABEL			"raw-md5"
#define FORMAT_NAME			"Raw MD5"
#define ALGORITHM_NAME			"raw-md5"

#define BENCHMARK_COMMENT		""
#define BENCHMARK_LENGTH		-1

#define PLAINTEXT_LENGTH		32
#define CIPHERTEXT_LENGTH		32

#define BINARY_SIZE			16
#define SALT_SIZE			0

#define MIN_KEYS_PER_CRYPT		1
#define MAX_KEYS_PER_CRYPT		1

static struct fmt_tests rawmd5_tests[] = {
	{"5a105e8b9d40e1329780d62ea2265d8a", "test1"},
	{"ad0234829205b9033196ba818f7a872b", "test2"},
	{"8ad8757baa8564dc136c1e07507f4a98", "test3"},
	{"86985e105f79b95d6bc918fb45ec7727", "test4"},
	{NULL}
};

static MD5_CTX ctx;

static char saved_key[PLAINTEXT_LENGTH + 1];
//stores the ciphertext for value currently being tested
static char crypt_key[BINARY_SIZE+1];

static int valid(char *ciphertext)
{
	int i;

	if (strlen(ciphertext) != CIPHERTEXT_LENGTH) return 0;
	for (i = 0; i < CIPHERTEXT_LENGTH; i++){
		if (!(  (('0' <= ciphertext[i])&&(ciphertext[i] <= '9')) ||
					(('a' <= ciphertext[i])&&(ciphertext[i] <= 'f'))  ))
			return 0;
	}
	return 1;
}

static void rawmd5_set_salt(void *salt) { }

static void rawmd5_set_key(char *key, int index) {
  strnzcpy(saved_key, key, PLAINTEXT_LENGTH+1);
}

static char *rawmd5_get_key(int index) {
    return saved_key;
}

static int rawmd5_cmp_all(void *binary, int index) { //also is mysql_cmp_one
	return !memcmp(binary, crypt_key, BINARY_SIZE);
}

static int rawmd5_cmp_exact(char *source, int count){
  return (1); //  mysql_cmp_all fallthrough?
}

static void rawmd5_crypt_all(int count) {  
  // get plaintext input in saved_key put it into ciphertext crypt_key
  MD5_Init( &ctx );
  MD5_Update( &ctx, saved_key, strlen( saved_key ) );
  MD5_Final( crypt_key, &ctx);
}

static void * rawmd5_binary(char *ciphertext) 
{
	static char realcipher[BINARY_SIZE];
	int i;
	
	for(i=0;i<BINARY_SIZE;i++)
	{
		realcipher[i] = atoi16[ARCH_INDEX(ciphertext[i*2])]*16 + atoi16[ARCH_INDEX(ciphertext[i*2+1])];
	}
	return (void *)realcipher;
}

struct fmt_main fmt_rawMD5 = {
	{
		FORMAT_LABEL,
		FORMAT_NAME,
		ALGORITHM_NAME,
		BENCHMARK_COMMENT,
		BENCHMARK_LENGTH,
		PLAINTEXT_LENGTH,
		BINARY_SIZE,
		SALT_SIZE,
		MIN_KEYS_PER_CRYPT,
		MAX_KEYS_PER_CRYPT,
		FMT_CASE | FMT_8_BIT,
		rawmd5_tests
	}, {
		fmt_default_init,
		valid,
		fmt_default_split,
		rawmd5_binary,
		fmt_default_salt,
		{
			fmt_default_binary_hash,
			fmt_default_binary_hash,
			fmt_default_binary_hash
		},
		fmt_default_salt_hash,
		rawmd5_set_salt,
		rawmd5_set_key,
		rawmd5_get_key,
		fmt_default_clear_keys,
		rawmd5_crypt_all,
		{
			fmt_default_get_hash,
			fmt_default_get_hash,
			fmt_default_get_hash
		},
		rawmd5_cmp_all,
		rawmd5_cmp_all,
		rawmd5_cmp_exact
	}
};
