/*
Modified by Balázs Bucsay <earthquake@rycon.hu>
2010. 01. 31.
*/

/*
   RainbowCrack - a general propose implementation of Philippe Oechslin's faster time-memory trade-off technique.

   Copyright (C) Zhu Shuanglei <shuanglei@hotmail.com>

   Changes: not using OpenSSL routines the slow way anymore, as suggested by jci.
*/

#include "md4.h"

char *_hash_mscache(unsigned char *pPlain, unsigned char *pLogin)
{
	char unicode_pwd[256];
	char unicode_user[256];
	unsigned char	final1[16];
	unsigned char	digest[16];	
	MD4_CTX ctx;
	int i;

	for (i=0; i<strlen(pPlain); i++)
	{
		unicode_pwd[i*2] = pPlain[i];
		unicode_pwd[i*2+1] = 0x00;
	}

	for (i=0; i<strlen(pLogin); i++)
	{
		unicode_user[i*2] = pLogin[i];
		unicode_user[i*2+1] = 0x00;
	}

	MD4Init(&ctx);
	MD4Update(&ctx,unicode_pwd,strlen(pPlain)*2);
	MD4Final(final1,&ctx);

	MD4Init(&ctx);
	MD4Update(&ctx,final1,16);
	MD4Update(&ctx,(unsigned char*) unicode_user,strlen(pLogin)*2);
	MD4Final(digest,&ctx);	

	for (i = 0; i < 16; i++) sprintf(finalhash+(i*2), "%02x", digest[i]);
  	finalhash[32] = 0;
  	
  	return finalhash;

}
