/*
   RainbowCrack - a general propose implementation of Philippe Oechslin's faster time-memory trade-off technique.

   Copyright (C) Zhu Shuanglei <shuanglei@hotmail.com>
*/

#include <stdio.h>
#include <string.h>
#include <openssl/des.h>

static char encrypted[20+1];

void setup_des_key(unsigned char *key_56, DES_key_schedule *ks)
{
	const_DES_cblock key;

	key[0] = key_56[0];
	key[1] = (key_56[0] << 7) | (key_56[1] >> 1);
	key[2] = (key_56[1] << 6) | (key_56[2] >> 2);
	key[3] = (key_56[2] << 5) | (key_56[3] >> 3);
	key[4] = (key_56[3] << 4) | (key_56[4] >> 4);
	key[5] = (key_56[4] << 3) | (key_56[5] >> 5);
	key[6] = (key_56[5] << 2) | (key_56[6] >> 6);
	key[7] = (key_56[6] << 1);

	DES_set_key(&key, ks);
}

char *_hash_lm(unsigned char *password)
{
	int i;
	unsigned char pHash[8];
	unsigned char pPlain[7];
	DES_key_schedule ks;
	static unsigned char magic[] = {0x4B, 0x47, 0x53, 0x21, 0x40, 0x23, 0x24, 0x25};

        memset(pPlain, 0, 7);
        strncpy(pPlain, password, strlen(password)<8?strlen(password):7);

	setup_des_key(pPlain, &ks);

	DES_ecb_encrypt((des_cblock*)magic, (des_cblock*)pHash, &ks, DES_ENCRYPT);

        sprintf(encrypted, "$LM$%02x%02x%02x%02x%02x%02x%02x%02x", pHash[0], pHash[1], pHash[2], pHash[3], pHash[4], pHash[5], pHash[6], pHash[7]);

        return encrypted;
}
