/*
  Cryptographic hash algorithm extension for PHP
  Implemented by Balzs Bucsay <earthquake@rycon.hu>
  2009

*/
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "php.h"
#include "php_cryptohash.h"

static function_entry cryptohash_functions[] = {
    PHP_FE(hash_mysql323, NULL)
    PHP_FE(hash_freebsd_md5, NULL)
    PHP_FE(hash_des, NULL)
    PHP_FE(hash_blowfish, NULL)
    PHP_FE(hash_krb4, NULL)
    PHP_FE(hash_lm, NULL)
    PHP_FE(hash_md4, NULL)
    PHP_FE(hash_mscache, NULL)
    {NULL, NULL, NULL}
};

zend_module_entry cryptohash_module_entry = {
#if ZEND_MODULE_API_NO >= 20010901
    STANDARD_MODULE_HEADER,
#endif
    PHP_CRYPTOHASH_EXTNAME,
    cryptohash_functions,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
#if ZEND_MODULE_API_NO >= 20010901
    PHP_CRYPTOHASH_VERSION,
#endif
    STANDARD_MODULE_PROPERTIES
};

#ifdef COMPILE_DL_CRYPTOHASH
ZEND_GET_MODULE(cryptohash)
#endif

/********************************  FREEBSD MD5  *******************************/

PHP_FUNCTION(hash_freebsd_md5)
{
    char *password, *salt;
    unsigned int password_len, salt_len;

    if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "ss", &password, &password_len, &salt, &salt_len) == FAILURE) {
        RETURN_NULL();
    }

    RETURN_STRING((unsigned char*)_hash_freebsd_md5(password, salt), 1);
}

/****************************** MYSQL 323 (Old) ******************************/

PHP_FUNCTION(hash_mysql323)
{
    unsigned long int hashback[2];
    char hash[17], *password;
    unsigned int password_len;

    memset(hash, '\0', 17);

    if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "s", &password, &password_len) == FAILURE) {
        RETURN_NULL();
    }

    _hash_mysql323(hashback, password, password_len);
    sprintf(hash, "%08lx%08lx", hashback[0], hashback[1]);

    RETURN_STRING(hash, 1);

}

/*************************** Traditional/BSDi DES ****************************/

PHP_FUNCTION(hash_des)
{
    char *password, *salt;
    unsigned int password_len, salt_len;

    if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "ss", &password, &password_len, &salt, &salt_len) == FAILURE) {
        RETURN_NULL();
    }

    RETURN_STRING((unsigned char*)_hash_des(password, salt), 1);

}

/**************************** OpenBSD Blowfish ******************************/

PHP_FUNCTION(hash_blowfish)
{
    char *password, *salt;
    unsigned int password_len, salt_len;

    if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "ss", &password, &password_len, &salt, &salt_len) == FAILURE) {
        RETURN_NULL();
    }

    RETURN_STRING((unsigned char*)_hash_blowfish(password, salt), 1);

}

/**************************** Kerberos AFS DES ******************************/

PHP_FUNCTION(hash_krb4)
{
    char *password, *salt;
    unsigned int password_len, salt_len;

    if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "ss", &password, &password_len, &salt, &salt_len) == FAILURE) {
        RETURN_NULL();
    }

    RETURN_STRING((unsigned char*)_hash_krb4(password, salt), 1);

}

/******************************* NT LM DES *********************************/

PHP_FUNCTION(hash_lm)
{
    char *password;
    unsigned int password_len;

    if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "s", &password, &password_len) == FAILURE) {
        RETURN_NULL();
    }

    RETURN_STRING((unsigned char*)_hash_lm(password), 1);

}

/******************************* MD4 *********************************/

PHP_FUNCTION(hash_md4)
{
    char *password;
    unsigned int password_len;

    if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "s", &password, &password_len) == FAILURE) {
        RETURN_NULL();
    }

    RETURN_STRING((unsigned char*)_hash_md4(password), 1);

}

/******************************* M$ CACHE *********************************/

PHP_FUNCTION(hash_mscache)
{
    char *password;
    unsigned int password_len;
    char *login;
    unsigned int login_len;    

    if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC, "ss", &password, &password_len, &login, &login_len) == FAILURE) {
        RETURN_NULL();
    }

    RETURN_STRING((unsigned char*)_hash_mscache(password, login), 1);

}
