#include <stdio.h>
#include <math.h>
#include <stdlib.h>

double euler = 2.71828182845;

double calcc(double *q, double *t, int s)
{
	double tau = 0.;
	double entropy = 0.;
	int i;
    
	for (i = 0; i<s; i++)
	{
		tau += t[i]*q[i];
		entropy += q[i]*log(q[i]);
	}
	entropy = -entropy;

	return (entropy/tau);
}

double g(double u, double *t, int s)
{
	int i;
	double temp = 0.0;
	
	for (i = 0; i < s; i++)
	{
		temp += pow(euler, -u*t[i]);
	}
	
	return temp;
}

double g_diff(double u, double *t, int s)
{
	int i;
	double temp = 0.0;
	
	for (i = 0; i < s; i++)
	{
		temp += -t[i]*pow(euler, -u*t[i]);
	}
	
	return temp;
}

double f_diff(double u, double *t, int s)
{
	return g_diff(u, t, s)/g(u, t, s);
}

double f(double u, double *t, int s)
{
	return log(g(u, t, s));
}

double nextuk(double uk, double *t, int s)
{
	return uk + (g(uk, t, s)*f(uk, t, s))/(-g_diff(uk, t, s));
}

void getqs(double u, double *t, int s, double *q)
{
	int i;
	
	for (i = 0 ; i < s ; i++)
	{
		q[i] = pow(euler, -u*t[i]);
	}
}

int main(int argc, char **argv)
{
	double *t;
	double *q;
	int s;
	int k = 0;
	double u = 0.0, old_u;
	double epszilon = 0.0000001;
	FILE *fd;
	
	if (argc != 2)
	{
		printf("Usage: %s filename\n", argv[0]);
		
		return -1;
	}
	
	if ((fd = fopen(argv[1], "r")) == NULL)
	{
		printf("File open error\n");
		
		return -1;
	}
	fscanf(fd, "%d\n", &s);
	if ((t = malloc(sizeof(double)*s)) == NULL)
	{
		printf("Memory alloc error."); 
		return -1;
	}
	for (k = 0; k < s; k++)
	{
		fscanf(fd, "%lf\n", &t[k]);
	}
	close(fd);
	
	k = 0;
	printf("k\tuk\t\tg(uk)\t\tf(uk)\t\t-g'(uk)\t\tDelta uk\n");
	do
	{
		printf("%d\t%lf\t%lf\t%lf\t%lf\t%lf\n", k, u, g(u, t, s), f(u, t, s), -g_diff(u, t, s), nextuk(u, t, s)-u);
		old_u = u;
		u = nextuk(u, t, s);
		k++;
	}
	while ((u - old_u) > epszilon); 
	
	if ((q = malloc(sizeof(double)*s)) == NULL)
	{
		printf("Memory alloc error."); 
		return -1;
	}
	
	getqs(u, t, s, q);
	for (k = 0 ; k < s ; k++)
	{
		printf("q%d: %.20lf\n", k, q[k]);
	}
	printf("Maximum channel capacity: %lf\n", calcc(q, t, s));

	free(q);
	
	return 0;
}
